/*
 * xbmstreamd.h	Header file for xbmstreamd.
 *
 * Version:	$Id:$
 *
 * Copyright:	(C)2007,2008 Miquel van Smoorenburg
 *
 *		This program is free software; you can redistribute it and/or
 *		modify it under the terms of the GNU General Public License
 *		as published by the Free Software Foundation; either version
 *		2 of the License, or (at your option) any later version.
 */

#ifndef XBMSTREAMD_H
#define XBMSTREAMD_H

#include <sys/types.h>
#include <dirent.h>

#define XVERSION	"xbmstreamd mediaserver/proxy 1.0"

/*
 *	Interface for backends.
 */
struct backend {
	char	*name;
	int	(*connect)(struct backend *);
	int	(*request)(struct backend *, struct xbmsp_packet *pkt);
	int	(*reply)(struct backend *, uint32_t, struct xbmsp_packet **pkt);
	int	(*netfd)(struct backend *);
	int	(*netio)(struct backend *, int mode);
	int	(*shutdown)(struct backend *);

	void	*clientconn;
};

struct backendopts {
	int		id;
	char		*name;
	char		*host;
	char		*port;
	int		af_family;
	struct sockaddr_storage	addr;
	int		cachesz;
	char		*directory;
	char		*htaccess;
};

/*
 *	Open file (in backend, usually)
 */
/* Open file */
struct filehandle {
	uint32_t		handle;		/* XBMSP handle */
	int			generation;	/* incremented every seek */
	int			streaming;	/* For readahead */
	int			type;
	DIR			*dir;
	int			fd;
	struct xbmsp_packet	*fileread_rp;	/* Buffered file contents */
	void			*aux;
	struct filehandle	*next;
};

#define FH_GENERATION_MAX	999999999
#define FH_TYPE_FILE		1
#define FH_TYPE_DIR		2

#define sockaddr_size(ss)	\
	((ss)->ss_family == AF_INET ? sizeof(struct sockaddr_in) : \
		((ss)->ss_family == AF_INET6 ? sizeof(struct sockaddr_in6) : \
		sizeof(struct sockaddr_storage)))

/*
 *	Global functions.
 */
void dumppacket(int id, char *label, struct xbmsp_packet *pkt);
void fh_inc_generation(struct filehandle *fh);
void fh_add(struct filehandle **fl, uint32_t handle);
struct filehandle *fh_find(struct filehandle *fl, uint32_t handle);
void fh_delete(struct filehandle **fl, uint32_t handle,
			void (*cleanup)(struct filehandle *));
void fh_deleteall(struct filehandle **fl, void (*cleanup)(struct filehandle *));
void queue_packet_to_client(struct backend *b, struct xbmsp_packet *pkt);

void logmsg(int severity, char *fmt, ...);

/*
 *	Available backends
 */
struct backend *backend_xbmsp_init(struct backendopts *bo, int id,
				char *clientaddr, void *cc);
struct backend *backend_file_init(struct backendopts *bo, int id,
				char *clientaddr, void *cc);

#endif /* XBMSTREAMD_H */
