/*
 * xbmsp.h	XBMSP library header file
 *
 * Version:	$Id:$
 *
 * Copyright:	(C)2007 Miquel van Smoorenburg
 *
 *		This program is free software; you can redistribute it and/or
 *		modify it under the terms of the GNU General Public License
 *		as published by the Free Software Foundation; either version
 *		2 of the License, or (at your option) any later version.
 */

#define XBMSP_PACKET_OK                         1
#define XBMSP_PACKET_ERROR                      2
#define XBMSP_PACKET_HANDLE                     3
#define XBMSP_PACKET_FILE_DATA                  4
#define XBMSP_PACKET_FILE_CONTENTS              5
#define XBMSP_PACKET_AUTHENTICATION_CONTINUE    6
#define XBMSP_PACKET_NULL                      10
#define XBMSP_PACKET_SETCWD                    11
#define XBMSP_PACKET_FILELIST_OPEN             12
#define XBMSP_PACKET_FILELIST_READ             13
#define XBMSP_PACKET_FILE_INFO                 14
#define XBMSP_PACKET_FILE_OPEN                 15
#define XBMSP_PACKET_FILE_READ                 16
#define XBMSP_PACKET_FILE_SEEK                 17
#define XBMSP_PACKET_CLOSE                     18
#define XBMSP_PACKET_CLOSE_ALL                 19
#define XBMSP_PACKET_SET_CONFIGURATION_OPTION  20
#define XBMSP_PACKET_AUTHENTICATION_INIT       21
#define XBMSP_PACKET_AUTHENTICATE              22
#define XBMSP_PACKET_UPCWD                     23

#define XBMSP_PACKET_SERVER_DISCOVERY_QUERY    90
#define XBMSP_PACKET_SERVER_DISCOVERY_REPLY    91

#define XBMSP_PACKET_UNKNOWN			199

/* XBMSP_PACKET_ERROR codes. */
#define XBMSP_ERROR_OK                         0 /* Reserved */
#define XBMSP_ERROR_FAILURE                    1
#define XBMSP_ERROR_UNSUPPORTED                2
#define XBMSP_ERROR_NO_SUCH_FILE               3
#define XBMSP_ERROR_INVALID_FILE               4
#define XBMSP_ERROR_INVALID_HANDLE             5
#define XBMSP_ERROR_OPEN_FAILED                6
#define XBMSP_ERROR_TOO_MANY_OPEN_FILES        7
#define XBMSP_ERROR_TOO_LONG_READ              8
#define XBMSP_ERROR_ILLEGAL_SEEK               9
#define XBMSP_ERROR_OPTION_IS_READ_ONLY        10
#define XBMSP_ERROR_INVALID_OPTION_VALUE       11
#define XBMSP_ERROR_AUTHENTICATION_NEEDED      12
#define XBMSP_ERROR_AUTHENTICATION_FAILED      13

/* Internal errors from xbmsp_ functions. */
#define XBMSP_E_SHORTREAD			-10001
#define XBMSP_E_SHORTWRITE			-10002
#define XBMSP_E_PKTSHORT			-10003
#define XBMSP_E_PKTCORR				-10004
#define XBMSP_E_ATTRMISS			-10005
#define XBMSP_E_ATTRCORR			-10006
#define XBMSP_E_UNKNOWNTYPE			-10007
#define XBMSP_E_UNEXPECTEDEOF			-10008

#define XBMSP_ATTR_BYTE				1
#define XBMSP_ATTR_INT32			2
#define XBMSP_ATTR_INT64			3
#define XBMSP_ATTR_STRING			4
#define XBMSP_ATTR_DATA				5

#define XBMSP_MAXATTR				8

#define XBMSP_VERSION	"XBMSP-1.0 1.0"

struct xbmsp_type {
	int		type;
	char		*name;
	char		*attrs;
};
extern struct xbmsp_type xbmsp_types[];

struct xbmsp_attr {
	int		type;
	int		length;
	union {
			uint32_t val32;
			uint64_t val64;
			char *string;
	};
};

struct xbmsp_packet {
	unsigned int		length;
	int			type;
	unsigned int		msgid;
	unsigned int		client_msgid;
	unsigned int		generation;
	struct xbmsp_attr	attrs[XBMSP_MAXATTR];
	int			nattrs;
	struct xbmsp_type	*xbmsp_type;
	struct xbmsp_packet	*next;
	char			data[1];
};

int xbmsp_buildpacket(struct xbmsp_packet **, int type, uint32_t msgid, ...);
struct xbmsp_packet *xbmsp_clonepacket(struct xbmsp_packet *pkt);
int xbmsp_dumppacket(struct xbmsp_packet *, char *res, int sz);
char *xbmsp_strerror(int err);
int xbmsp_recvpacketfrom(int fd, struct xbmsp_packet **pkt,
                        struct sockaddr *addr, int *addrlen);
int xbmsp_recvpacket(int fd, struct xbmsp_packet **);
int xbmsp_sendpacketto(int fd, struct xbmsp_packet *packet,
                        struct sockaddr *addr, int addrlen);
int xbmsp_sendpacket(int fd, struct xbmsp_packet *);
int xbmsp_readident(int fd, char *ident, int sz);
int xbmsp_sendident(int fd, char *ident, int sz);
void xbmsp_freepackets(struct xbmsp_packet **pktlist);

#ifdef __linux__
void strlcpy(char *dst, char *src, int sz);
void strlcat(char *dst, char *src, int sz);
#endif

